	function [N, Be, D, W] = L_PHASE_BP_FIR_ORDER(wT_edge, d)
 
	% 	Estmates the required order for a linear-phase bandpass FIR filter.
	%	Normalized band edges (NORMALIZED 0 < wcT < ): 
	%	
	%		wT_edge = [ws1T wc1T wc2T ws2T]
	%
	%	We assume that the band edges are in rad.
	%	Passband ripple, dc, and stopband ripples, ds1 and ds2.	
	%
	%		d = [ds1 dc ds2]
	%
	%	Outputs:
	%		Formated for direct use by EQR_FIR.m and firmp.m or remez.m
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	%	Author: 			Lars Wanhammar 2003-07-29
	%	Modfied by:			LW 2004-09-22, 2014-11-17
	% 	Copyright:			by authors - not released for commercial use
	%	Version: 			1 
	%	Known bugs:			
	% 	Report bugs to:		Wanhammar@gmail.com
	%
	%	Reference:	Mintzer F. and Liu B.: Practical design rules for optimum FIR 
	%				bandpass digital filters, IEEE Trans. on Acoustics, Speech and 
	%				Signal Processing, Vol. ASSP-27, No. 2, pp. 204-206, April 1979.
	
	if ~(wT_edge(1) <wT_edge(2) | wT_edge(2) < wT_edge(3) | wT_edge(3) < wT_edge(4))
		error('Improper band edges. Edges should be: ws1T< wc1T < wc2T < ws2T.')
	end
	DwT = min(wT_edge(2)-wT_edge(1),wT_edge(4)-wT_edge(3))/(2*pi);
	DwTmax = max(wT_edge(2)-wT_edge(1),wT_edge(4)-wT_edge(3))/(2*pi);
	R = DwTmax/DwT;
	xc = log10(d(2));
	xs = log10(min(d(1),d(3)));
	b1 = 0.01201; 
	b2 = 0.09664; 
	b3 = -0.51325; 
	b4 = 0.00203;
	b5 = -0.57054; 
	b6 = -0.44314;		
	C = ((b1*xc + b2)*xc + b3)*xs + (b4*xc + b5)*xc + b6;
	G = 14.6*(xc-xs) + 16.9;	
	N = floor((C/DwT + G*DwT + 1)*(1 - 0.034*(R-2)));
	Be = [0 wT_edge(1) wT_edge(2) wT_edge(3) wT_edge(4) pi];
	D = [0 0 1 1 0 0];
	W = [d(2)/d(1) 1 d(2)/d(3)];
	
